/*******************************************************************************
* Device      : AD18F08
* Author      : ADIC DD lizz
* Version     : V0.0.1
* Date        : 20230504
* Description : EMC复位为关键寄存器比对复位，关键寄存器不开放；
* Note        : 1、本功能使用时打开EMCEN
********************************************************************************/

#include "AD18F08.h"
#include <stdio.h>
#include "common.h"


/*********************************************************************************************
* 常用配置字功能说明：
*
* _FINTOSC_DIV1  :  内部时钟分频选择
* _LVREN_ON      :  使能LVR                 OFF:禁止                           ON:使能
* _LVT22V        ： 选择LVR电压为2.2V
* _DBG_OFF       :  禁用DEBUG模式（使能后将固定PA1和PA2为DEBUG_IO）OFF:禁止    ON:使能
* _CKSUM_OFF     ： 使能程序校验
* _MEMDIS_OFF    ： SWD模式下读FLASH和EEPROM控位                   OFF:禁止    ON:允许
* _OSCM_HIRC_16M ： 选择内部高速时钟16MHz
* _FCPU_4T       ： 选择指令周期为4T模式
* _RDPIN_ON      ： 读端口方式控制位        OFF:从寄存器读(IO配置为输出)       ON:从管脚读(IO配置为输入)
* _RESETE_OFF    ： 禁用外部复位            OFF:禁止                           ON:使能
* _ENVDDL_OFF    ： FLASH的低电压读使能位   OFF:禁止                           ON:使能
* _SMT_SMV       ： 电平选择位         		_SMT_SMV:选择施密特               _SMT_TTL:选择TTL电平
* _CRYPT_OFF     :  代码保护选择位          OFF:代码不加密                     ON:代码加密
* _WDTEN_OFF     ： 使能看门狗              OFF:禁止                           ON:使能
* _TWDT_000      :  选择看门狗溢出时间为128.4ms
*
* 注意：1.配置字若无特别需求请勿修改；
*       2.其他配置字及相应功能见Datasheet及头文件；
*
************************************************************************************************/

__CONFIG(1,_FINTOSC_DIV1_1L     & _DBG_OFF_1L       & _LVREN_OFF_1L     & _LVR24V_1L                                                  );
__CONFIG(2,_FLASH_CP1_OFF_2L    & _FLASH_CP0_OFF_2L & _IDIS_OFF_2L     & _CKSUM_OFF_2L  & _CBP_OFF_2L   & _RESETE_OFF_2L & _RSEL_LOW_2L & _STV_ON_2L  );
__CONFIG(3,_PSUT_2_3L           & _FCPU_4T_3L       & _WDTE_OFF_3L    & _TWDT_111_3L                                                );
__CONFIG(4,_OSCM_HIRC_16M_4L    & _MTPDIS_OFF_4L    &_ADCSP_ON_4L                                                                                      );

volatile unsigned char Chip_ID = 0;
static volatile unsigned char	TEST0                 @0xf07;
static volatile bit	 TESTEN                          @((unsigned)&TEST0*8)+7;
static volatile unsigned char	TEST1                 @0xf04;
//本DEMO验证EMC复位功能，临时定义；
volatile unsigned char i = 0;

void main (void)
{
	GPIO_Init();     //所有IO初始化
	TRISB1 = 0;		 //PB1输出模式
	TRISB3 = 0;      //PB3输出模式
	if(POR&LVR==1)
	{
		for(i=0;i<200;i++)
		{
		    PB3 =~ PB3;
		    __delay_us(100);
		}
	}
	POR=1;
	LVR=1;

	EMCEN = 1;      //打开EMC复位使能

		for(i=0;i<50;i++)
		{
            PB1 =~ PB1;
		    __delay_us(100);
		}
	while(1)
	{
		TESTEN=1;
		TEST1 = 0x80;       //模拟寄存器干扰后，值发生变化，引起复位
	}
}

//高优先级中断服务函数

void interrupt ISR_h (void)
{

}

//低优先级中断服务函数
void interrupt low_priority ISR_l (void)
{
//进入中断后系统自动关闭中断
}

